/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.auditing;

import it.geosolutions.geostore.services.rest.auditing.AuditingFilesManager;
import it.geosolutions.geostore.services.rest.auditing.AuditingTestsBase;
import it.geosolutions.geostore.services.rest.auditing.AuditingTestsUtils;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public final class AuditingFilesManagerTest
extends AuditingTestsBase {
    @Test
    public void testCleanInit() {
        AuditingFilesManager auditingFilesManager = new AuditingFilesManager(this.OUTPUT_DIRECTORY.getPath(), "txt");
        File expectedOutputFile = new File(this.OUTPUT_DIRECTORY, "audit-geostore.txt");
        Assert.assertEquals((Object)auditingFilesManager.getOutputFile(), (Object)expectedOutputFile);
        AuditingTestsUtils.checkDirectoryContainsFiles(this.OUTPUT_DIRECTORY, expectedOutputFile);
    }

    @Test
    public void testInitWithExistingFiles() {
        AuditingTestsUtils.createFile(new File(this.OUTPUT_DIRECTORY, "audit-geostore.txt"), "existing1");
        AuditingFilesManager auditingFilesManager = new AuditingFilesManager(this.OUTPUT_DIRECTORY.getPath(), "txt");
        File expectedOutputFile = new File(this.OUTPUT_DIRECTORY, "audit-geostore.txt");
        File expectedExistingFile = new File(this.OUTPUT_DIRECTORY, String.format("audit-geostore-%s-1.txt", auditingFilesManager.getCurrentDayTag()));
        Assert.assertEquals((Object)auditingFilesManager.getOutputFile(), (Object)expectedOutputFile);
        AuditingTestsUtils.checkDirectoryContainsFiles(this.OUTPUT_DIRECTORY, expectedOutputFile, expectedExistingFile);
        AuditingTestsUtils.checkFileExistsWithContent(expectedExistingFile, "existing1");
        AuditingTestsUtils.checkFileExistsWithContent(expectedOutputFile, "");
    }

    @Test
    public void testRollingFiles() {
        AuditingFilesManager auditingFilesManager = new AuditingFilesManager(this.OUTPUT_DIRECTORY.getPath(), "txt");
        File expectedOutputFile = new File(this.OUTPUT_DIRECTORY, "audit-geostore.txt");
        Assert.assertEquals((Object)auditingFilesManager.getOutputFile(), (Object)expectedOutputFile);
        AuditingTestsUtils.checkDirectoryContainsFiles(this.OUTPUT_DIRECTORY, expectedOutputFile);
        AuditingTestsUtils.writeToFile(expectedOutputFile, "rolled1");
        auditingFilesManager.rollOutputFile();
        File expectedExistingFile1 = new File(this.OUTPUT_DIRECTORY, String.format("audit-geostore-%s-1.txt", auditingFilesManager.getCurrentDayTag()));
        AuditingTestsUtils.checkDirectoryContainsFiles(this.OUTPUT_DIRECTORY, expectedOutputFile, expectedExistingFile1);
        AuditingTestsUtils.checkFileExistsWithContent(expectedExistingFile1, "rolled1");
        AuditingTestsUtils.checkFileExistsWithContent(expectedOutputFile, "");
        String previousCurrentTagDay = auditingFilesManager.getCurrentDayTag();
        AuditingTestsUtils.writeToFile(expectedOutputFile, "rolled2");
        auditingFilesManager.rollOutputFile();
        int rolledFileIndex = previousCurrentTagDay.equals(auditingFilesManager.getCurrentDayTag()) ? 2 : 1;
        File expectedExistingFile2 = new File(this.OUTPUT_DIRECTORY, String.format("audit-geostore-%s-%d.txt", auditingFilesManager.getCurrentDayTag(), rolledFileIndex));
        AuditingTestsUtils.checkDirectoryContainsFiles(this.OUTPUT_DIRECTORY, expectedOutputFile, expectedExistingFile1, expectedExistingFile2);
        AuditingTestsUtils.checkFileExistsWithContent(expectedExistingFile1, "rolled1");
        AuditingTestsUtils.checkFileExistsWithContent(expectedExistingFile2, "rolled2");
        AuditingTestsUtils.checkFileExistsWithContent(expectedOutputFile, "");
    }

    @Test
    public void testMakeFileExists() {
        AuditingFilesManager auditingFilesManager = new AuditingFilesManager(this.OUTPUT_DIRECTORY.getPath(), "txt");
        File expectedOutputFile = new File(this.OUTPUT_DIRECTORY, "audit-geostore.txt");
        Assert.assertEquals((Object)auditingFilesManager.getOutputFile(), (Object)expectedOutputFile);
        AuditingTestsUtils.checkDirectoryContainsFiles(this.OUTPUT_DIRECTORY, expectedOutputFile);
        AuditingTestsUtils.deleteFile(expectedOutputFile);
        AuditingTestsUtils.checkDirectoryIsEmpty(this.OUTPUT_DIRECTORY);
        auditingFilesManager.makeOutputFileExists();
        AuditingTestsUtils.checkDirectoryContainsFiles(this.OUTPUT_DIRECTORY, expectedOutputFile);
    }
}

