/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.auditing;

import it.geosolutions.geostore.services.rest.auditing.AuditingConfiguration;
import it.geosolutions.geostore.services.rest.auditing.AuditingTestsBase;
import it.geosolutions.geostore.services.rest.auditing.AuditingTestsUtils;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public final class AuditingConfigurationTest
extends AuditingTestsBase {
    @Test
    public void testSimpleConfiguration() {
        AuditingConfiguration auditingConfiguration = new AuditingConfiguration();
        Assert.assertEquals((Object)auditingConfiguration.isAuditEnable(), (Object)true);
        Assert.assertEquals((long)auditingConfiguration.getMaxRequestPerFile(), (long)3L);
        Assert.assertEquals((long)auditingConfiguration.getTemplatesVersion(), (long)1L);
        Assert.assertEquals((Object)auditingConfiguration.getOutputDirectory(), (Object)this.OUTPUT_DIRECTORY.getAbsolutePath());
        Assert.assertEquals((Object)auditingConfiguration.getOutputFilesExtension(), (Object)"txt");
        Assert.assertEquals((Object)auditingConfiguration.getTemplatesDirectory(), (Object)this.TEMPLATES_DIRECTORY.getAbsolutePath());
    }

    @Test
    public void testUpdateConfiguration() {
        AuditingConfiguration auditingConfiguration = new AuditingConfiguration();
        Assert.assertEquals((Object)auditingConfiguration.isAuditEnable(), (Object)true);
        Map<String, String> properties = AuditingTestsUtils.getDefaultProperties(this.OUTPUT_DIRECTORY, this.TEMPLATES_DIRECTORY);
        properties.put("auditing.enable", "false");
        AuditingTestsUtils.createFile(this.CONFIGURATION_FILE_PATH, AuditingTestsUtils.propertiesToString(properties));
        AuditingConfiguration newAuditingConfiguration = auditingConfiguration.checkForNewConfiguration();
        Assert.assertNotNull((Object)newAuditingConfiguration);
    }
}

