/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.auditing;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.rest.auditing.AuditInfo;
import it.geosolutions.geostore.services.rest.auditing.AuditInfoExtractor;
import it.geosolutions.geostore.services.rest.auditing.AuditingTestsBase;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.security.core.Authentication;

public final class AuditInfoExtractorTest
extends AuditingTestsBase {
    private static HttpServletRequest getHttpServletRequest() {
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)httpServletRequest.getRemoteAddr()).thenReturn((Object)"127.0.0.1");
        Mockito.when((Object)httpServletRequest.getRemoteHost()).thenReturn((Object)"127.0.0.1");
        Mockito.when((Object)httpServletRequest.getRemoteUser()).thenReturn((Object)"User[id=2, name=admin, group=[UserGroup[id=1, groupName=everyone]], role=ADMIN]");
        Mockito.when((Object)httpServletRequest.getServerName()).thenReturn((Object)"localhost");
        UserGroup userGroup = (UserGroup)Mockito.mock(UserGroup.class);
        Mockito.when((Object)userGroup.getGroupName()).thenReturn((Object)"everyone");
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getName()).thenReturn((Object)"admin");
        Mockito.when((Object)user.getRole()).thenReturn((Object)Role.ADMIN);
        Mockito.when((Object)user.getGroups()).thenReturn(Collections.singleton(userGroup));
        Authentication authentication = (Authentication)Mockito.mock(Authentication.class);
        Mockito.when((Object)authentication.getPrincipal()).thenReturn((Object)user);
        Mockito.when((Object)httpServletRequest.getUserPrincipal()).thenReturn((Object)authentication);
        return httpServletRequest;
    }

    private static InputStream getInputStream(String content) {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)inputStream.toString()).thenReturn((Object)content);
        return inputStream;
    }

    private static Message getInMessage() {
        Message inMessage = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)inMessage.get((Object)"org.apache.cxf.request.method")).thenReturn((Object)"GET");
        Mockito.when((Object)inMessage.get((Object)Message.PATH_INFO)).thenReturn((Object)"/geostore/users/user/15");
        Mockito.when((Object)inMessage.get((Object)Message.BASE_PATH)).thenReturn((Object)"/geostore/users");
        Mockito.when((Object)inMessage.get((Object)Message.QUERY_STRING)).thenReturn(null);
        HttpServletRequest httpServletRequest = AuditInfoExtractorTest.getHttpServletRequest();
        Mockito.when((Object)inMessage.get((Object)"HTTP.REQUEST")).thenReturn((Object)httpServletRequest);
        InputStream inputStream = AuditInfoExtractorTest.getInputStream("body-content");
        Mockito.when((Object)((InputStream)inMessage.getContent(InputStream.class))).thenReturn((Object)inputStream);
        return inMessage;
    }

    private static Message getOutSuccessMessage() {
        Message outSuccessMessage = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)outSuccessMessage.get((Object)Message.RESPONSE_CODE)).thenReturn((Object)"200");
        Mockito.when((Object)outSuccessMessage.get((Object)"Content-Type")).thenReturn((Object)"application/octet-stream");
        Exchange exchange = (Exchange)Mockito.mock(Exchange.class);
        Mockito.when((Object)exchange.get((Object)AuditInfo.RESPONSE_LENGTH.getKey())).thenReturn((Object)150);
        Mockito.when((Object)outSuccessMessage.getExchange()).thenReturn((Object)exchange);
        return outSuccessMessage;
    }

    private static CachedOutputStream getCacheOutputStream() {
        CachedOutputStream outputStream = (CachedOutputStream)Mockito.mock(CachedOutputStream.class);
        Mockito.when((Object)outputStream.size()).thenReturn((Object)100L);
        return outputStream;
    }

    private static Message getOutFaultMessage() {
        Message outFaultMessage = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)((Exception)outFaultMessage.getContent(Exception.class))).thenReturn((Object)new Exception("exception-message"));
        Mockito.when((Object)outFaultMessage.get((Object)Message.RESPONSE_CODE)).thenReturn((Object)"500");
        Mockito.when((Object)outFaultMessage.get((Object)"Content-Type")).thenReturn((Object)"application/octet-stream");
        CachedOutputStream outputStream = AuditInfoExtractorTest.getCacheOutputStream();
        Mockito.when((Object)((OutputStream)outFaultMessage.getContent(OutputStream.class))).thenReturn((Object)outputStream);
        return outFaultMessage;
    }

    @Test
    public void testSuccessExecution() {
        Message message = (Message)Mockito.mock(Message.class);
        Exchange exchange = (Exchange)Mockito.mock(Exchange.class);
        Message inMessage = AuditInfoExtractorTest.getInMessage();
        Mockito.when((Object)message.getExchange()).thenReturn((Object)exchange);
        Mockito.when((Object)exchange.getInMessage()).thenReturn((Object)inMessage);
        Message outSuccessMessage = AuditInfoExtractorTest.getOutSuccessMessage();
        Mockito.when((Object)exchange.getOutMessage()).thenReturn((Object)outSuccessMessage);
        Mockito.when((Object)exchange.get((Object)AuditInfo.START_TIME.getKey())).thenReturn((Object)1000L);
        Map auditInfo = AuditInfoExtractor.extract((Message)message);
        Assert.assertEquals((long)auditInfo.size(), (long)18L);
        Assert.assertEquals(auditInfo.get(AuditInfo.HOST.getKey()), (Object)"localhost");
        Assert.assertEquals(auditInfo.get(AuditInfo.RESPONSE_CONTENT_TYPE.getKey()), (Object)"application/octet-stream");
        Assert.assertEquals(auditInfo.get(AuditInfo.HTTP_METHOD.getKey()), (Object)"GET");
        Assert.assertEquals(auditInfo.get(AuditInfo.BODY_AS_STRING.getKey()), (Object)"body-content");
        Assert.assertEquals(auditInfo.get(AuditInfo.USER_ROLE.getKey()), (Object)"ADMIN");
        Assert.assertEquals(auditInfo.get(AuditInfo.REMOTE_HOST.getKey()), (Object)"127.0.0.1");
        Assert.assertEquals(auditInfo.get(AuditInfo.START_TIME.getKey()), (Object)"1000");
        Assert.assertEquals(auditInfo.get(AuditInfo.RESPONSE_LENGTH.getKey()), (Object)"150");
        Assert.assertEquals(auditInfo.get(AuditInfo.BASE_PATH.getKey()), (Object)"users");
        Assert.assertEquals(auditInfo.get(AuditInfo.QUERY_STRING.getKey()), (Object)"");
        Assert.assertEquals(auditInfo.get(AuditInfo.USER_GROUPS.getKey()), (Object)"everyone");
        Assert.assertEquals(auditInfo.get(AuditInfo.RESPONSE_STATUS_CODE.getKey()), (Object)"200");
        Assert.assertEquals(auditInfo.get(AuditInfo.PATH.getKey()), (Object)"users/user/15");
        Assert.assertEquals(auditInfo.get(AuditInfo.USER_NAME.getKey()), (Object)"admin");
        Assert.assertEquals(auditInfo.get(AuditInfo.REMOTE_ADDR.getKey()), (Object)"127.0.0.1");
        Assert.assertEquals(auditInfo.get(AuditInfo.REMOTE_USER.getKey()), (Object)"User[id=2, name=admin, group=[UserGroup[id=1, groupName=everyone]], role=ADMIN]");
        Assert.assertNotNull(auditInfo.get(AuditInfo.END_TIME.getKey()));
        Assert.assertEquals((long)Long.parseLong((String)auditInfo.get(AuditInfo.TOTAL_TIME.getKey())), (long)(Long.parseLong((String)auditInfo.get(AuditInfo.END_TIME.getKey())) - 1000L));
    }

    @Test
    public void testFaultExecution() {
        Message message = (Message)Mockito.mock(Message.class);
        Exchange exchange = (Exchange)Mockito.mock(Exchange.class);
        Message inMessage = AuditInfoExtractorTest.getInMessage();
        Mockito.when((Object)message.getExchange()).thenReturn((Object)exchange);
        Mockito.when((Object)exchange.getInMessage()).thenReturn((Object)inMessage);
        Message outFaultMessage = AuditInfoExtractorTest.getOutFaultMessage();
        Mockito.when((Object)exchange.getOutFaultMessage()).thenReturn((Object)outFaultMessage);
        Mockito.when((Object)exchange.get((Object)AuditInfo.START_TIME.getKey())).thenReturn((Object)1000L);
        Map auditInfo = AuditInfoExtractor.extract((Message)message);
        Assert.assertEquals((long)auditInfo.size(), (long)20L);
        Assert.assertEquals(auditInfo.get(AuditInfo.HOST.getKey()), (Object)"localhost");
        Assert.assertEquals(auditInfo.get(AuditInfo.RESPONSE_CONTENT_TYPE.getKey()), (Object)"application/octet-stream");
        Assert.assertEquals(auditInfo.get(AuditInfo.HTTP_METHOD.getKey()), (Object)"GET");
        Assert.assertEquals(auditInfo.get(AuditInfo.BODY_AS_STRING.getKey()), (Object)"body-content");
        Assert.assertEquals(auditInfo.get(AuditInfo.USER_ROLE.getKey()), (Object)"ADMIN");
        Assert.assertEquals(auditInfo.get(AuditInfo.REMOTE_HOST.getKey()), (Object)"127.0.0.1");
        Assert.assertEquals(auditInfo.get(AuditInfo.START_TIME.getKey()), (Object)"1000");
        Assert.assertEquals(auditInfo.get(AuditInfo.RESPONSE_LENGTH.getKey()), (Object)"100");
        Assert.assertEquals(auditInfo.get(AuditInfo.BASE_PATH.getKey()), (Object)"users");
        Assert.assertEquals(auditInfo.get(AuditInfo.QUERY_STRING.getKey()), (Object)"");
        Assert.assertEquals(auditInfo.get(AuditInfo.USER_GROUPS.getKey()), (Object)"everyone");
        Assert.assertEquals(auditInfo.get(AuditInfo.RESPONSE_STATUS_CODE.getKey()), (Object)"500");
        Assert.assertEquals(auditInfo.get(AuditInfo.PATH.getKey()), (Object)"users/user/15");
        Assert.assertEquals(auditInfo.get(AuditInfo.USER_NAME.getKey()), (Object)"admin");
        Assert.assertEquals(auditInfo.get(AuditInfo.REMOTE_ADDR.getKey()), (Object)"127.0.0.1");
        Assert.assertEquals(auditInfo.get(AuditInfo.REMOTE_USER.getKey()), (Object)"User[id=2, name=admin, group=[UserGroup[id=1, groupName=everyone]], role=ADMIN]");
        Assert.assertEquals(auditInfo.get(AuditInfo.ERROR_MESSAGE.getKey()), (Object)"exception-message");
        Assert.assertEquals(auditInfo.get(AuditInfo.FAILED.getKey()), (Object)"true");
        Assert.assertNotNull(auditInfo.get(AuditInfo.END_TIME.getKey()));
        Assert.assertEquals((long)Long.parseLong((String)auditInfo.get(AuditInfo.TOTAL_TIME.getKey())), (long)(Long.parseLong((String)auditInfo.get(AuditInfo.END_TIME.getKey())) - 1000L));
    }
}

