/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.auditing;

import it.geosolutions.geostore.services.rest.auditing.AuditingException;
import it.geosolutions.geostore.services.rest.auditing.LogUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class AuditingFilesManager {
    private static final Logger logger = LogManager.getLogger(AuditingFilesManager.class);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
    private final File outputDirectory;
    private final String fileExtension;
    private File outputFile;
    private String currentDayTag;
    private Pattern filePattern;

    AuditingFilesManager(String outputDirectoryPath, String fileExtension) {
        this.outputDirectory = new File(outputDirectoryPath);
        this.fileExtension = fileExtension;
        this.init();
    }

    File rollOutputFile() {
        this.updateCurrentDay();
        if (this.outputFile.exists()) {
            int rollingValue = this.getNextRollingValue();
            File rollingFile = new File(this.outputDirectory, this.getRollinFileName(rollingValue));
            this.moveOutputFile(rollingFile);
        }
        this.createOutputFile();
        return this.outputFile;
    }

    File getOutputFile() {
        return this.outputFile;
    }

    String getCurrentDayTag() {
        return this.currentDayTag;
    }

    void makeOutputFileExists() {
        if (!this.outputFile.exists()) {
            this.createOutputFile();
        }
    }

    private void init() {
        this.updateCurrentDay();
        this.outputFile = new File(this.outputDirectory, String.format("audit-geostore.%s", this.fileExtension));
        if (this.outputDirectory.exists()) {
            LogUtils.info(logger, "Output directory '%s' exists.", this.outputDirectory.getPath());
            this.handleExistingOutputDirectory();
        } else {
            LogUtils.info(logger, "Creating output directory '%s'.", this.outputDirectory.getPath());
            try {
                FileUtils.forceMkdir((File)this.outputDirectory);
            }
            catch (Exception exception) {
                throw new AuditingException(exception, "Error creating output directory '%s'.", this.outputDirectory);
            }
        }
    }

    private void handleExistingOutputDirectory() {
        if (this.outputFile.exists()) {
            this.rollOutputFile();
        } else {
            this.createOutputFile();
        }
    }

    private void updateCurrentDay() {
        String dayTag = this.dateFormat.format(new Date());
        if (this.currentDayTag == null || !this.currentDayTag.equals(dayTag)) {
            LogUtils.debug(logger, "Current day '%s' will be updates to '%s'.", this.currentDayTag, dayTag);
            this.currentDayTag = dayTag;
            this.filePattern = Pattern.compile("audit-geostore-" + this.currentDayTag + "-(\\d+)\\." + this.fileExtension + "$");
        }
    }

    private String getRollinFileName(int nextRollingValue) {
        return String.format("audit-geostore-%s-%d.%s", this.currentDayTag, nextRollingValue, this.fileExtension);
    }

    private void moveOutputFile(File rollingFile) {
        LogUtils.info(logger, "Rolling output file '%s' to '%s'.", this.outputFile.getPath(), rollingFile.getPath());
        try {
            FileUtils.moveFile((File)this.outputFile, (File)rollingFile);
        }
        catch (Exception exception) {
            throw new AuditingException(exception, "Error moving output file '%s' to rolling file '%s'.", this.outputFile.getPath(), rollingFile.getPath());
        }
    }

    private void createOutputFile() {
        try {
            LogUtils.info(logger, "Creating output file '%s'.", this.outputFile.getPath());
            FileUtils.touch((File)this.outputFile);
        }
        catch (Exception exception) {
            throw new AuditingException(exception, "Error creating output file '%s'.", this.outputFile.getPath());
        }
    }

    private int getNextRollingValue() {
        List<Integer> rollingValues = this.getRollingValues();
        int nextRollingValue = 1;
        if (!rollingValues.isEmpty()) {
            Collections.sort(rollingValues);
            nextRollingValue = rollingValues.get(rollingValues.size() - 1) + 1;
        }
        LogUtils.debug(logger, "Next rolling value for day '%s' will be '%d'.", this.currentDayTag, nextRollingValue);
        return nextRollingValue;
    }

    private List<Integer> getRollingValues() {
        String[] files;
        ArrayList<Integer> rollingValues = new ArrayList<Integer>();
        for (String file : files = this.listOutputDirectoryFiles()) {
            Matcher matcher = this.filePattern.matcher(file);
            if (!matcher.matches()) continue;
            rollingValues.add(Integer.parseInt(matcher.group(1)));
        }
        return rollingValues;
    }

    private String[] listOutputDirectoryFiles() {
        String[] files = this.outputDirectory.list();
        if (files == null) {
            throw new AuditingException("Error listing files of output directory '%s'.", this.outputDirectory);
        }
        LogUtils.debug(logger, "Output directory current files: %s.", LogUtils.arrayToString(files));
        return files;
    }
}

