/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.model;

import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.services.rest.model.RESTIPRange;
import it.geosolutions.geostore.services.rest.model.RESTUser;
import it.geosolutions.geostore.services.rest.model.RESTUserGroup;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="SecurityRule")
public class RESTSecurityRule {
    private RESTUser user = null;
    private RESTUserGroup group = null;
    private boolean canRead = false;
    private boolean canWrite = false;
    @XmlElementWrapper(name="ipRanges")
    @XmlElement(name="ipRange")
    private List<RESTIPRange> ipRanges = null;

    public RESTSecurityRule(SecurityRule rule) {
        if (rule.getUser() != null) {
            User ruleUser = rule.getUser();
            this.user = new RESTUser();
            this.user.setId(ruleUser.getId());
            this.user.setName(ruleUser.getName());
        }
        if (rule.getGroup() != null) {
            UserGroup ruleGroup = rule.getGroup();
            this.group = new RESTUserGroup();
            this.group.setId(ruleGroup.getId());
            this.group.setGroupName(ruleGroup.getGroupName());
        }
        this.canRead = rule.isCanRead();
        this.canWrite = rule.isCanWrite();
        if (rule.getIpRanges() != null) {
            this.ipRanges = rule.getIpRanges().stream().map(RESTIPRange::new).collect(Collectors.toList());
        }
    }

    public RESTSecurityRule() {
    }

    public RESTUser getUser() {
        return this.user;
    }

    public void setUser(RESTUser user) {
        this.user = user;
    }

    public RESTUserGroup getGroup() {
        return this.group;
    }

    public void setGroup(RESTUserGroup group) {
        this.group = group;
    }

    public boolean isCanRead() {
        return this.canRead;
    }

    public void setCanRead(boolean canRead) {
        this.canRead = canRead;
    }

    public boolean isCanWrite() {
        return this.canWrite;
    }

    public void setCanWrite(boolean canWrite) {
        this.canWrite = canWrite;
    }

    @XmlTransient
    public List<RESTIPRange> getIpRanges() {
        return this.ipRanges;
    }

    public void setIpRanges(List<RESTIPRange> ipRanges) {
        this.ipRanges = ipRanges;
    }
}

