/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.model;

import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.core.model.enums.Role;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="User")
public class RESTUser
implements Serializable {
    private static final long serialVersionUID = -3004145977232782933L;
    private Long id;
    private String name;
    private Role role;
    private List<String> groupsNames;

    public RESTUser() {
    }

    public RESTUser(Long id) {
        this.id = id;
    }

    public RESTUser(String name) {
        this.name = name;
    }

    public RESTUser(Long id, String name, Role role, Set<UserGroup> groups, boolean allGroups) {
        this.id = id;
        this.name = name;
        this.role = role;
        this.groupsNames = new ArrayList<String>();
        if (groups != null) {
            for (UserGroup ug : groups) {
                if (!allGroups && !GroupReservedNames.isAllowedName((String)ug.getGroupName())) continue;
                this.groupsNames.add(ug.getGroupName());
            }
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public List<String> getGroupsNames() {
        return this.groupsNames;
    }

    public void setGroupsNames(List<String> groupsNames) {
        this.groupsNames = groupsNames;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append('[');
        if (this.id != null) {
            builder.append("id=").append(this.id);
        }
        if (this.name != null) {
            builder.append(", ");
            builder.append("name=").append(this.name);
        }
        if (this.role != null) {
            builder.append(", ");
            builder.append("role=").append(this.role);
        }
        builder.append(']');
        return builder.toString();
    }
}

