/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.utils;

import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.StoredData;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.AccessType;
import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.dto.ShortAttribute;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.dto.search.AndFilter;
import it.geosolutions.geostore.services.dto.search.AttributeFilter;
import it.geosolutions.geostore.services.dto.search.BaseField;
import it.geosolutions.geostore.services.dto.search.CategoryFilter;
import it.geosolutions.geostore.services.dto.search.FieldFilter;
import it.geosolutions.geostore.services.dto.search.NotFilter;
import it.geosolutions.geostore.services.dto.search.OrFilter;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.SearchOperator;
import it.geosolutions.geostore.services.rest.model.CategoryList;
import it.geosolutions.geostore.services.rest.model.RESTCategory;
import it.geosolutions.geostore.services.rest.model.RESTQuickBackup;
import it.geosolutions.geostore.services.rest.model.RESTResource;
import it.geosolutions.geostore.services.rest.model.RESTStoredData;
import it.geosolutions.geostore.services.rest.model.ShortAttributeList;
import it.geosolutions.geostore.services.rest.model.ShortResourceList;
import it.geosolutions.geostore.services.rest.model.StoredDataList;
import it.geosolutions.geostore.services.rest.model.UserGroupList;
import it.geosolutions.geostore.services.rest.model.UserList;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.xml.bind.JAXBContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GeoStoreJAXBContext {
    private static final Logger LOGGER = LogManager.getLogger(GeoStoreJAXBContext.class);
    private static final JAXBContext context = GeoStoreJAXBContext.createNewContext();

    public static JAXBContext createNewContext() {
        JAXBContext tmpContext = null;
        try {
            List<Class> allClasses = GeoStoreJAXBContext.getGeoStoreClasses();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Initializing GeoStoreJAXBContext with " + allClasses.size() + " classes " + allClasses);
            }
            tmpContext = JAXBContext.newInstance((Class[])allClasses.toArray(new Class[allClasses.size()]));
        }
        catch (Exception ex) {
            LOGGER.error("Can't create GeoStore context: " + ex.getMessage(), (Throwable)ex);
        }
        return tmpContext;
    }

    public static List<Class> getGeoStoreClasses() {
        List<Class<? extends Serializable>> coreModelClasses = GeoStoreJAXBContext.getModelClasses();
        List<Class<? extends Serializable>> serviceApiClasses = GeoStoreJAXBContext.getAPIclasses();
        List<Class<?>> restApiClasses = GeoStoreJAXBContext.getRESTclasses();
        ArrayList<Class> allClasses = new ArrayList<Class>(coreModelClasses.size() + serviceApiClasses.size() + restApiClasses.size());
        allClasses.addAll(coreModelClasses);
        allClasses.addAll(serviceApiClasses);
        allClasses.addAll(restApiClasses);
        return allClasses;
    }

    private static List<Class<? extends Serializable>> getModelClasses() {
        return Arrays.asList(Attribute.class, Category.class, UserGroup.class, Resource.class, SecurityRule.class, StoredData.class, User.class, UserAttribute.class, UserGroup.class, AccessType.class, DataType.class, Role.class);
    }

    private static List<Class<? extends Serializable>> getAPIclasses() {
        return Arrays.asList(ShortAttribute.class, ShortResource.class, AndFilter.class, AttributeFilter.class, BaseField.class, CategoryFilter.class, FieldFilter.class, NotFilter.class, OrFilter.class, SearchFilter.class, SearchOperator.class);
    }

    private static List<Class<?>> getRESTclasses() {
        return Arrays.asList(CategoryList.class, UserGroupList.class, RESTResource.class, RESTCategory.class, StoredDataList.class, ShortAttributeList.class, UserList.class, ShortResourceList.class, RESTStoredData.class, RESTQuickBackup.class, RESTQuickBackup.RESTBackupCategory.class, RESTQuickBackup.RESTBackupResource.class);
    }

    public static JAXBContext getContext() {
        if (context == null) {
            throw new IllegalStateException("Context has not been properly initialized");
        }
        return context;
    }

    private static List<Class> getClasses(String packageName) throws ClassNotFoundException, IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading classes from " + packageName);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String fileName = resource.getFile();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("   adding resource " + fileName);
            }
            String fileNameDecoded = URLDecoder.decode(fileName, "UTF-8");
            dirs.add(new File(fileNameDecoded));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(GeoStoreJAXBContext.findClasses(directory, packageName));
        }
        return classes;
    }

    private static List<Class> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            LOGGER.debug("Directory not found :" + directory);
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            Class<?> _class;
            String fileName = file.getName();
            if (file.isDirectory()) {
                assert (!fileName.contains("."));
                classes.addAll(GeoStoreJAXBContext.findClasses(file, packageName + "." + fileName));
                continue;
            }
            if (!fileName.endsWith(".class") || fileName.contains("$")) continue;
            try {
                _class = Class.forName(packageName + '.' + fileName.substring(0, fileName.length() - 6));
            }
            catch (ExceptionInInitializerError e) {
                _class = Class.forName(packageName + '.' + fileName.substring(0, fileName.length() - 6), false, Thread.currentThread().getContextClassLoader());
            }
            classes.add(_class);
        }
        return classes;
    }
}

