/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest;

import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.model.RESTUserGroup;
import it.geosolutions.geostore.services.rest.model.ShortResourceList;
import it.geosolutions.geostore.services.rest.model.UserGroupList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.springframework.security.access.annotation.Secured;

public interface RESTUserGroupService {
    @POST
    @Path(value="/")
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    @Produces(value={"text/plain"})
    @Secured(value={"ROLE_ADMIN"})
    public long insert(@Context SecurityContext var1, @Multipart(value="userGroup") RESTUserGroup var2) throws BadRequestWebEx;

    @DELETE
    @Path(value="/group/{id}")
    @Secured(value={"ROLE_ADMIN"})
    public void delete(@Context SecurityContext var1, @PathParam(value="id") long var2) throws NotFoundWebEx;

    @GET
    @Path(value="/group/{id}")
    @Secured(value={"ROLE_ADMIN"})
    @Produces(value={"text/xml", "application/json"})
    public RESTUserGroup get(@Context SecurityContext var1, @PathParam(value="id") long var2, @QueryParam(value="includeattributes") @DefaultValue(value="true") boolean var4) throws NotFoundWebEx;

    @GET
    @Path(value="/group/name/{name}")
    @Secured(value={"ROLE_ADMIN"})
    @Produces(value={"text/xml", "application/json"})
    public RESTUserGroup get(@Context SecurityContext var1, @PathParam(value="name") String var2, @QueryParam(value="includeattributes") @DefaultValue(value="true") boolean var3) throws NotFoundWebEx;

    @POST
    @Path(value="/group/{userid}/{groupid}")
    @Secured(value={"ROLE_ADMIN"})
    public void assignUserGroup(@Context SecurityContext var1, @PathParam(value="userid") long var2, @PathParam(value="groupid") long var4) throws NotFoundWebEx;

    @DELETE
    @Path(value="/group/{userid}/{groupid}")
    @Secured(value={"ROLE_ADMIN"})
    public void deassignUserGroup(@Context SecurityContext var1, @PathParam(value="userid") long var2, @PathParam(value="groupid") long var4) throws NotFoundWebEx;

    @GET
    @Path(value="/")
    @Produces(value={"text/xml", "application/json"})
    @Secured(value={"ROLE_ADMIN"})
    public UserGroupList getAll(@Context SecurityContext var1, @QueryParam(value="page") Integer var2, @QueryParam(value="entries") Integer var3, @QueryParam(value="all") @DefaultValue(value="false") boolean var4, @QueryParam(value="users") @DefaultValue(value="true") boolean var5) throws BadRequestWebEx;

    @PUT
    @Path(value="/update_security_rules/{groupId}/{canRead}/{canWrite}")
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    @Produces(value={"text/xml", "application/json"})
    @Secured(value={"ROLE_ADMIN"})
    public ShortResourceList updateSecurityRules(@Context SecurityContext var1, @Multipart(value="resourcelist") ShortResourceList var2, @PathParam(value="groupId") Long var3, @PathParam(value="canRead") Boolean var4, @PathParam(value="canWrite") Boolean var5) throws BadRequestWebEx, NotFoundWebEx;

    @PUT
    @Path(value="/group/{id}")
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    @Produces(value={"text/plain"})
    @Secured(value={"ROLE_ADMIN"})
    public long update(@Context SecurityContext var1, @PathParam(value="id") long var2, @Multipart(value="userGroup") RESTUserGroup var4) throws NotFoundWebEx;

    @GET
    @Path(value="/search/attribute/{name}/{value}")
    @Produces(value={"text/xml", "application/json"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public UserGroupList getByAttribute(@Context SecurityContext var1, @PathParam(value="name") String var2, @PathParam(value="value") String var3, @QueryParam(value="ignoreCase") @DefaultValue(value="false") boolean var4);

    @GET
    @Path(value="/search/attribute/{name}")
    @Produces(value={"text/xml", "application/json"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public UserGroupList getByAttribute(@Context SecurityContext var1, @PathParam(value="name") String var2, @QueryParam(value="values") List<String> var3, @QueryParam(value="ignoreCase") @DefaultValue(value="false") boolean var4);
}

