/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.model.UserList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.springframework.security.access.annotation.Secured;

public interface RESTUserService {
    @POST
    @Path(value="/")
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Secured(value={"ROLE_ADMIN"})
    public long insert(@Context SecurityContext var1, @Multipart(value="user") User var2) throws BadRequestServiceEx, NotFoundServiceEx;

    @PUT
    @Path(value="/user/{id}")
    @Consumes(value={"application/xml", "text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN"})
    public long update(@Context SecurityContext var1, @PathParam(value="id") long var2, @Multipart(value="user") User var4) throws NotFoundWebEx;

    @DELETE
    @Path(value="/user/{id}")
    @Secured(value={"ROLE_ADMIN"})
    public void delete(@Context SecurityContext var1, @PathParam(value="id") long var2) throws NotFoundWebEx;

    @GET
    @Path(value="/user/{id}")
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Secured(value={"ROLE_ADMIN"})
    public User get(@Context SecurityContext var1, @PathParam(value="id") long var2, @QueryParam(value="includeattributes") @DefaultValue(value="false") boolean var4) throws NotFoundWebEx;

    @GET
    @Path(value="/search/{name}")
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Secured(value={"ROLE_ADMIN"})
    public User get(@Context SecurityContext var1, @PathParam(value="name") String var2, @QueryParam(value="includeattributes") @DefaultValue(value="false") boolean var3) throws NotFoundWebEx;

    @GET
    @Path(value="/")
    @Secured(value={"ROLE_ADMIN"})
    public UserList getAll(@Context SecurityContext var1, @QueryParam(value="page") Integer var2, @QueryParam(value="entries") Integer var3) throws BadRequestWebEx;

    @GET
    @Path(value="/count/{nameLike}")
    @Secured(value={"ROLE_ADMIN"})
    public long getCount(@Context SecurityContext var1, @PathParam(value="nameLike") String var2);

    @GET
    @Path(value="/user/details/")
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN"})
    public User getAuthUserDetails(@Context SecurityContext var1, @QueryParam(value="includeattributes") @DefaultValue(value="false") boolean var2);

    @GET
    @Path(value="/search/list/{nameLike}")
    @Produces(value={"text/plain", "text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN"})
    public UserList getUserList(@Context SecurityContext var1, @PathParam(value="nameLike") String var2, @QueryParam(value="page") Integer var3, @QueryParam(value="entries") Integer var4, @QueryParam(value="includeattributes") @DefaultValue(value="false") boolean var5) throws BadRequestWebEx;
}

