/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.dao.impl;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.dao.ResourceDAO;
import it.geosolutions.geostore.core.dao.impl.BaseDAO;
import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.Resource;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.NoResultException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Hibernate;
import org.springframework.transaction.annotation.Transactional;

@Transactional(value="geostoreTransactionManager")
public class ResourceDAOImpl
extends BaseDAO<Resource, Long>
implements ResourceDAO {
    private static final Logger LOGGER = LogManager.getLogger(ResourceDAOImpl.class);

    public void persist(Resource ... entities) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("Inserting new entities for Resource ... ");
        }
        int size = entities.length;
        Date creation = new Date();
        for (int i = 0; i < size; ++i) {
            entities[i].setCreation(creation);
        }
        super.persist((Object[])entities);
    }

    @Override
    public List<Resource> findAll() {
        return super.findAll();
    }

    @Override
    public Resource find(Long id) {
        return (Resource)super.find((Serializable)id);
    }

    @Override
    public List<Attribute> findAttributes(long resourceId) {
        Search searchCriteria = new Search(Resource.class);
        searchCriteria.addField("attribute");
        Filter securityFilter = Filter.some((String)"attribute", (Filter)Filter.equal((String)"resource.id", (Object)resourceId));
        searchCriteria.addFilter(securityFilter);
        return super.search((ISearch)searchCriteria);
    }

    @Override
    public List<Resource> search(ISearch search) {
        return super.search(search);
    }

    @Override
    public Resource merge(Resource entity) {
        entity.setLastUpdate(new Date());
        return (Resource)super.merge((Object)entity);
    }

    @Override
    public boolean remove(Resource entity) {
        return super.remove((Object)entity);
    }

    @Override
    public void removeResources(ISearch search) {
        List resources = super.search(search);
        super.remove((Object[])resources.toArray(new Resource[1]));
    }

    @Override
    public boolean removeById(Long id) {
        return super.removeById((Serializable)id);
    }

    @Override
    public List<Resource> findResources(List<Long> resourcesIds) {
        Search search = new Search(Resource.class);
        Filter filter = Filter.in((String)"id", resourcesIds);
        search.addFilter(filter);
        List resourceToSet = super.search((ISearch)search);
        for (Resource resource : resourceToSet) {
            if (Hibernate.isInitialized((Object)resource.getSecurity())) continue;
            Hibernate.initialize((Object)resource.getSecurity());
        }
        return resourceToSet;
    }

    @Override
    public Resource findByName(String resourceName) {
        Search searchCriteria = new Search(Resource.class);
        Filter filter = Filter.equal((String)"name", (Object)resourceName);
        searchCriteria.addFilter(filter);
        Resource foundResource = null;
        try {
            foundResource = (Resource)super.searchUnique((ISearch)searchCriteria);
        }
        catch (NoResultException ex) {
            foundResource = null;
        }
        return foundResource;
    }

    @Override
    public List<String> findResourceNamesMatchingPattern(String pattern) {
        Search searchCriteria = new Search(Resource.class);
        searchCriteria.addField("name");
        searchCriteria.addFilterLike("name", pattern);
        searchCriteria.setResultMode(4);
        List resourceNames = super.search((ISearch)searchCriteria);
        return resourceNames;
    }

    @Override
    public List<Resource> findUserFavorites(Long userId) {
        Search searchCriteria = new Search(Resource.class);
        searchCriteria.addFilter(Filter.some((String)"favoritedBy", (Filter)Filter.equal((String)"id", (Object)userId)));
        return super.search((ISearch)searchCriteria);
    }
}

