package it.geosolutions.geostore.core.dao.impl;

import com.googlecode.genericdao.search.ISearch;
import it.geosolutions.geostore.core.dao.UserGroupAttributeDAO;
import it.geosolutions.geostore.core.model.UserGroupAttribute;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@Transactional(value = "geostoreTransactionManager")
public class UserGroupAttributeDAOImpl extends BaseDAO<UserGroupAttribute, Long>
        implements UserGroupAttributeDAO {

    private static final Logger LOGGER = LogManager.getLogger(UserGroupAttributeDAOImpl.class);

    /*
     * (non-Javadoc)
     *
     * @see com.trg.dao.jpa.GenericDAOImpl#persist(T[])
     */
    @Override
    public void persist(UserGroupAttribute... entities) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("Inserting new entities for UserGroupAttribute ... ");
        }

        super.persist(entities);
    }

    /*
     * (non-Javadoc)
     *
     * @see com.trg.dao.jpa.GenericDAOImpl#findAll()
     */
    @Override
    public List<UserGroupAttribute> findAll() {
        return super.findAll();
    }

    /*
     * (non-Javadoc)
     *
     * @see com.trg.dao.jpa.GenericDAOImpl#search(com.trg.search.ISearch)
     */
    @SuppressWarnings("unchecked")
    @Override
    public List<UserGroupAttribute> search(ISearch search) {
        return super.search(search);
    }

    /*
     * (non-Javadoc)
     *
     * @see com.trg.dao.jpa.GenericDAOImpl#merge(java.lang.Object)
     */
    @Override
    public UserGroupAttribute merge(UserGroupAttribute entity) {
        return super.merge(entity);
    }

    /*
     * (non-Javadoc)
     *
     * @see com.trg.dao.jpa.GenericDAOImpl#remove(java.lang.Object)
     */
    @Override
    public boolean remove(UserGroupAttribute entity) {
        return super.remove(entity);
    }

    /*
     * (non-Javadoc)
     *
     * @see com.trg.dao.jpa.GenericDAOImpl#removeById(java.io.Serializable)
     */
    @Override
    public boolean removeById(Long id) {
        return super.removeById(id);
    }
}
