/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.model;

import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.enums.DataType;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@Entity(name="Attribute")
@Table(name="gs_attribute", uniqueConstraints={@UniqueConstraint(columnNames={"name", "resource_id"})}, indexes={@Index(name="idx_attribute_name", columnList="name"), @Index(name="idx_attribute_text", columnList="attribute_text"), @Index(name="idx_attribute_number", columnList="attribute_number"), @Index(name="idx_attribute_date", columnList="attribute_date"), @Index(name="idx_attribute_type", columnList="attribute_type"), @Index(name="idx_attribute_resource", columnList="resource_id")})
@XmlRootElement(name="Attribute")
public class Attribute
implements Serializable {
    private static final long serialVersionUID = -1298676702253831972L;
    @Id
    @GeneratedValue
    private Long id;
    @Column(name="name", nullable=false, updatable=true)
    private String name;
    @Column(name="attribute_text", nullable=true, updatable=true)
    private String textValue;
    @Column(name="attribute_number", nullable=true, updatable=true)
    private Double numberValue;
    @Column(name="attribute_date", nullable=true, updatable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateValue;
    @Column(name="attribute_type", nullable=false, updatable=false)
    @Enumerated(value=EnumType.STRING)
    private DataType type;
    @ManyToOne(optional=false)
    @JoinColumn(foreignKey=@ForeignKey(name="fk_attribute_resource"))
    private Resource resource;
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    @PreUpdate
    @PrePersist
    public void onPreUpdate() throws Exception {
        if (this.textValue == null && this.numberValue == null && this.dateValue == null) {
            throw new NullPointerException("Null value not allowed in attribute: " + this.toString());
        }
        if (!(this.textValue == null && this.numberValue != null ^ this.dateValue != null || this.numberValue == null && this.dateValue == null)) {
            throw new Exception("Only one DataType can be not-null inside the Attribute entity: " + this.toString());
        }
        this.type = this.textValue != null ? DataType.STRING : (this.numberValue != null ? DataType.NUMBER : DataType.DATE);
    }

    @XmlTransient
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlTransient
    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    @XmlTransient
    public Double getNumberValue() {
        return this.numberValue;
    }

    public void setNumberValue(Double numberValue) {
        this.numberValue = numberValue;
    }

    @XmlTransient
    public Date getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(Date dateValue) {
        this.dateValue = dateValue;
    }

    @Transient
    @XmlElement
    public String getValue() {
        switch (this.type) {
            case DATE: {
                return new SimpleDateFormat(DATE_FORMAT).format(this.dateValue);
            }
            case NUMBER: {
                return this.numberValue.toString();
            }
            case STRING: {
                return this.textValue.toString();
            }
        }
        throw new IllegalStateException("Unknown type " + this.type);
    }

    protected void setValue(String text) {
        if (this.type == null) {
            throw new IllegalStateException("Setting value with no type selected");
        }
        this.setValue(text, this.type);
    }

    protected void setValue(String text, DataType type) {
        switch (type) {
            case DATE: {
                try {
                    this.dateValue = new SimpleDateFormat(DATE_FORMAT).parse(text);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Can't parse date [" + text + "]", e);
                }
            }
            case NUMBER: {
                try {
                    this.numberValue = Double.valueOf(text);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Can't parse double [" + text + "]", e);
                }
            }
            case STRING: {
                this.textValue = text;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type " + type);
            }
        }
    }

    @XmlAttribute
    public DataType getType() {
        return this.type;
    }

    public void setType(DataType type) {
        this.type = type;
    }

    @XmlTransient
    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append('[');
        if (this.id != null) {
            builder.append("id=").append(this.id);
        } else {
            builder.append("id is null");
        }
        if (this.name != null) {
            builder.append(", name=").append(this.name);
        }
        if (this.textValue != null) {
            builder.append(", textValue=").append(this.textValue);
        }
        if (this.numberValue != null) {
            builder.append(", numberValue=").append(this.numberValue);
        }
        if (this.dateValue != null) {
            builder.append(", dateValue=").append(this.dateValue);
        }
        if (this.textValue == null && this.numberValue == null && this.dateValue == null) {
            builder.append(", value is null");
        }
        if (this.type != null) {
            builder.append(", type=").append((Object)this.type);
        }
        builder.append(']');
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dateValue == null ? 0 : this.dateValue.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.numberValue == null ? 0 : this.numberValue.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.textValue == null ? 0 : this.textValue.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attribute other = (Attribute)obj;
        if (this.dateValue == null ? other.dateValue != null : !this.dateValue.equals(other.dateValue)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.numberValue == null ? other.numberValue != null : !this.numberValue.equals(other.numberValue)) {
            return false;
        }
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        if (this.textValue == null ? other.textValue != null : !this.textValue.equals(other.textValue)) {
            return false;
        }
        return this.type == other.type;
    }
}

