/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.model;

import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity(name="UserGroup")
@Table(name="gs_usergroup", uniqueConstraints={@UniqueConstraint(columnNames={"groupName"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="gs_usergroup")
@XmlRootElement(name="UserGroup")
public class UserGroup
implements Serializable {
    private static final long serialVersionUID = 6065837305601115748L;
    @Id
    @GeneratedValue
    private Long id;
    @Column(nullable=false, updatable=false, length=20)
    @Index(name="idx_usergroup_name")
    private String groupName;
    @Column(nullable=true, updatable=true, length=200)
    private String description;
    @OneToMany(mappedBy="group", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<SecurityRule> security;
    @Type(type="yes_no")
    @Column(nullable=false, updatable=true)
    private boolean enabled = true;
    @ManyToMany(mappedBy="groups", fetch=FetchType.EAGER)
    @Index(name="idx_group_user")
    private Set<User> users;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @XmlTransient
    public List<SecurityRule> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<SecurityRule> security) {
        this.security = security;
    }

    @XmlTransient
    public Set<User> getUsers() {
        return this.users;
    }

    public void setUsers(Set<User> users) {
        this.users = users;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append('[');
        if (this.id != null) {
            builder.append("id=").append(this.id);
        }
        if (this.groupName != null) {
            builder.append(", ");
            builder.append("groupName=").append(this.groupName);
        }
        builder.append(']');
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupName == null ? 0 : this.groupName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.security == null ? 0 : ((Object)this.security).hashCode());
        result = 31 * result + (this.users == null ? 0 : ((Object)this.users).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserGroup other = (UserGroup)obj;
        if (this.groupName == null ? other.groupName != null : !this.groupName.equals(other.groupName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.security == null ? other.security != null : !((Object)this.security).equals(other.security)) {
            return false;
        }
        return !(this.users == null ? other.users != null : !((Object)this.users).equals(other.users));
    }
}

