/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.model;

import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity(name="User")
@Table(name="gs_user", uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="gs_user")
@XmlRootElement(name="User")
public class User
implements Serializable {
    private static final long serialVersionUID = -138056245004697133L;
    @Id
    @GeneratedValue
    private Long id;
    @Column(nullable=false, updatable=false, length=20)
    @Index(name="idx_user_name")
    private String name;
    @Column(name="user_password", updatable=true)
    @Index(name="idx_user_password")
    private String password;
    @Column(name="user_role", nullable=false, updatable=true)
    @Index(name="idx_user_role")
    @Enumerated(value=EnumType.STRING)
    private Role role;
    private transient String newPassword = null;
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<UserAttribute> attribute;
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<SecurityRule> security;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="gs_usergroup_members", joinColumns={@JoinColumn(name="user_id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="group_id", nullable=false, updatable=false)})
    @Index(name="idx_user_group")
    private Set<UserGroup> groups;
    @Type(type="yes_no")
    @Column(nullable=false, updatable=true)
    private boolean enabled = true;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @XmlElementWrapper
    @XmlElement(name="group")
    public Set<UserGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<UserGroup> groups) {
        this.groups = groups;
    }

    @XmlTransient
    public List<SecurityRule> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<SecurityRule> security) {
        this.security = security;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlTransient
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public List<UserAttribute> getAttribute() {
        return this.attribute;
    }

    public void setAttribute(List<UserAttribute> attribute) {
        this.attribute = attribute;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append('[');
        if (this.id != null) {
            builder.append("id=").append(this.id);
        }
        if (this.name != null) {
            builder.append(", ");
            builder.append("name=").append(this.name);
        }
        if (this.groups != null) {
            builder.append(", ");
            builder.append("group=").append(this.groups.toString());
        }
        if (this.role != null) {
            builder.append(", ");
            builder.append("role=").append((Object)this.role);
        }
        builder.append(']');
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attribute == null ? 0 : ((Object)this.attribute).hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.security == null ? 0 : ((Object)this.security).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        if (this.attribute == null ? other.attribute != null : !((Object)this.attribute).equals(other.attribute)) {
            return false;
        }
        if (this.groups == null ? other.groups != null : !((Object)this.groups).equals(other.groups)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.role != other.role) {
            return false;
        }
        return !(this.security == null ? other.security != null : !((Object)this.security).equals(other.security));
    }
}

