/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.model;

import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;

@Entity(name="Security")
@Table(name="gs_security", uniqueConstraints={@UniqueConstraint(columnNames={"user_id", "resource_id"}), @UniqueConstraint(columnNames={"resource_id", "group_id"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="gs_security")
@XmlRootElement(name="Security")
public class SecurityRule
implements Serializable {
    private static final long serialVersionUID = -4160546863296343389L;
    @Id
    @GeneratedValue
    private Long id;
    @ManyToOne(optional=true)
    @Index(name="idx_security_resource")
    @ForeignKey(name="fk_security_resource")
    private Resource resource;
    @ManyToOne(optional=true)
    @Index(name="idx_security_user")
    @ForeignKey(name="fk_security_user")
    private User user;
    @ManyToOne(optional=true)
    @Index(name="idx_security_group")
    @ForeignKey(name="fk_security_group")
    private UserGroup group;
    @Column(nullable=false, updatable=true)
    @Index(name="idx_security_read")
    private boolean canRead;
    @Column(nullable=false, updatable=true)
    @Index(name="idx_security_write")
    private boolean canWrite;

    @PreUpdate
    @PrePersist
    public void onPreUpdate() throws Exception {
    }

    @XmlTransient
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @XmlTransient
    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @XmlTransient
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @XmlTransient
    public UserGroup getGroup() {
        return this.group;
    }

    public void setGroup(UserGroup group) {
        this.group = group;
    }

    @XmlTransient
    public boolean isCanRead() {
        return this.canRead;
    }

    public void setCanRead(boolean canRead) {
        this.canRead = canRead;
    }

    @XmlTransient
    public boolean isCanWrite() {
        return this.canWrite;
    }

    public void setCanWrite(boolean canWrite) {
        this.canWrite = canWrite;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append('[');
        if (this.id != null) {
            builder.append("id=").append(this.id);
        }
        builder.append(", ");
        builder.append("canRead=").append(this.canRead);
        builder.append(", ");
        builder.append("canWrite=").append(this.canWrite);
        if (this.resource != null) {
            builder.append(", ");
            builder.append("resource=").append(this.resource);
        }
        if (this.group != null) {
            builder.append(", ");
            builder.append("group=").append(this.group);
        }
        builder.append(']');
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.canRead ? 1231 : 1237);
        result = 31 * result + (this.canWrite ? 1231 : 1237);
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityRule other = (SecurityRule)obj;
        if (this.canRead != other.canRead) {
            return false;
        }
        if (this.canWrite != other.canWrite) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }
}

