/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.model;

import com.sun.xml.bind.CycleRecoverable;
import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.StoredData;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;

@Entity(name="Resource")
@Table(name="gs_resource", uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="gs_resource")
@XmlRootElement(name="Resource")
public class Resource
implements Serializable,
CycleRecoverable {
    private static final long serialVersionUID = 4852100679788007328L;
    @Id
    @GeneratedValue
    private Long id;
    @Column(nullable=false, updatable=true)
    @Index(name="idx_resource_name")
    private String name;
    @Column(nullable=true, updatable=true, length=10000)
    @Index(name="idx_resource_description")
    private String description;
    @Column(nullable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="idx_resource_creation")
    private Date creation;
    @Column(nullable=true, updatable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="idx_resource_update")
    private Date lastUpdate;
    @Column(nullable=true, updatable=true, length=30000)
    @Index(name="idx_resource_metadata")
    private String metadata;
    @OneToMany(mappedBy="resource", cascade={CascadeType.REMOVE}, fetch=FetchType.EAGER)
    private List<Attribute> attribute;
    @OneToOne(mappedBy="resource", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private StoredData data;
    @ManyToOne(optional=false)
    @Index(name="idx_resource_category")
    @ForeignKey(name="fk_resource_category")
    private Category category;
    @OneToMany(mappedBy="resource", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<SecurityRule> security;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getCreation() {
        return this.creation;
    }

    public void setCreation(Date creation) {
        this.creation = creation;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    @XmlElementWrapper(name="Attributes")
    public List<Attribute> getAttribute() {
        return this.attribute;
    }

    public void setAttribute(List<Attribute> attribute) {
        this.attribute = attribute;
    }

    public StoredData getData() {
        return this.data;
    }

    public void setData(StoredData data) {
        this.data = data;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    @XmlTransient
    public List<SecurityRule> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<SecurityRule> security) {
        this.security = security;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append('[');
        if (this.name != null) {
            builder.append("name=").append(this.name);
        }
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        if (this.creation != null) {
            builder.append(", ");
            builder.append("creation=").append(this.creation);
        }
        if (this.lastUpdate != null) {
            builder.append(", ");
            builder.append("lastUpdate=").append(this.lastUpdate);
        }
        if (this.metadata != null) {
            builder.append(", ");
            builder.append("metadata=").append(this.metadata);
        }
        if (this.attribute != null) {
            builder.append(", ");
            builder.append("attribute=").append(this.attribute.toString());
        }
        if (this.data != null) {
            builder.append(", ");
            builder.append("data=").append(this.data.toString());
        }
        if (this.category != null) {
            builder.append(", ");
            builder.append("category=").append(this.category.toString());
        }
        builder.append(']');
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attribute == null ? 0 : ((Object)this.attribute).hashCode());
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.creation == null ? 0 : this.creation.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.lastUpdate == null ? 0 : this.lastUpdate.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.security == null ? 0 : ((Object)this.security).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.attribute == null ? other.attribute != null : !((Object)this.attribute).equals(other.attribute)) {
            return false;
        }
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        if (this.creation == null ? other.creation != null : !this.creation.equals(other.creation)) {
            return false;
        }
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.lastUpdate == null ? other.lastUpdate != null : !this.lastUpdate.equals(other.lastUpdate)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.security == null ? other.security != null : !((Object)this.security).equals(other.security));
    }

    public Object onCycleDetected(CycleRecoverable.Context arg0) {
        Resource r = new Resource();
        r.setCreation(this.creation);
        r.setDescription(this.description);
        r.setLastUpdate(this.lastUpdate);
        r.setMetadata(this.metadata);
        r.setName(this.name);
        r.setAttribute(null);
        r.setData(null);
        return r;
    }
}

